extern float4x4	g_Proj :		register(c0);
extern float	g_Distance :	register(c4);



struct VS_OUTPUT
{
	float4	m_Position :	POSITION;
	float2	m_TexCoord :	TEXCOORD0;
	float	m_Depth :		TEXCOORD1;
};



struct VS_INPUT
{
 	float4	m_Position :	POSITION;
	float2	m_TexCoord :	TEXCOORD0;
};




/*
 * Particles vertex shader
 */
VS_OUTPUT MainVS(VS_INPUT input)
{
 	VS_OUTPUT output	=	(VS_OUTPUT) 0;

	float4	position	=	input.m_Position;
	float	theta		=	0.5f * (g_Distance + position.z);
	float	phi			=	0.5f * g_Distance;
	
	float2	change;
	float2	origin;
	sincos(theta, change.x, change.y);
	sincos(phi, origin.x, origin.y);
	position.xy			+=	0.5f * (change.xy - origin.xy);
	
	output.m_Position	=	mul(position, g_Proj);
	output.m_TexCoord	=	input.m_TexCoord + float2(0.0f, 0.5f * g_Distance);
	output.m_Depth		=	output.m_Position.z / 100.0f;

	return output;
}